$videoFolder = "C:\records"
$ffmpegPath = "C:\ProgramData\chocolatey\bin\ffmpeg.exe"
$rtspUrl = "rtsp://192.168.1.102/h265/ch1/main/av_stream"

# Создаем папку, если её нет
if (-not (Test-Path -Path $videoFolder)) {
    New-Item -Path $videoFolder -ItemType Directory
    Write-Host "Directory created: $videoFolder"
} else {
    Write-Host "Directory already exists: $videoFolder"
}

# Функция для проверки свободного места
function Check-FreeSpace {
    $requiredFreeSpaceGB = 100
    $freeSpaceGB = [math]::round((Get-PSDrive -Name C).Free / 1GB, 2)
    return $freeSpaceGB
}

# Функция для удаления самого старого файла, если недостаточно места
function Remove-OldestFile {
    $f = Get-ChildItem -Path $videoFolder | Sort-Object CreationTime | Select-Object -First 1
    if ($f) { Remove-Item $f.FullName }
}

# Бесконечный цикл для записи видео
while ($true) {
    $freeSpace = Check-FreeSpace

    # Проверка на минимально необходимое пространство на диске (10 Гб)
    if ($freeSpace -lt 10) {
        Write-Host "Error: Insufficient disk space. Free space is only ${freeSpace}GB. Exiting..."
        break
    }

    # Проверка и удаление старых записей, если свободного места недостаточно
    while ($freeSpace -lt 50) {
        Remove-OldestFile
        $freeSpace = Check-FreeSpace
    }

    # Создаем имя файла на основе текущего времени
    $date = Get-Date -Format "yyyy-MM-dd_HH-mm-ss"
    $fileName = "$videoFolder\record-$date.ts"

    Write-Host "Starting recording: $fileName"

    # Расчет времени до полуночи
    $now = Get-Date
    $nextMidnight = $now.Date.AddDays(1)
    $remainingTime = [math]::Round(($nextMidnight - $now).TotalSeconds)

    # Запуск записи на оставшееся время до полуночи с H.265 и пониженным битрейтом
    Start-Process -FilePath $ffmpegPath -ArgumentList @(
        "-t", $remainingTime,
        "-rtsp_transport", "tcp",
        "-i", $rtspUrl,
        "-vf", "scale=480:480,drawtext=fontfile=C\\:/Windows/Fonts/segoeui.ttf:text=`%{localtime}:x=10:y=10:fontsize=24:fontcolor=white:borderw=2:bordercolor=black",
        "-vcodec", "libx264",
        "-preset", "slower",
        "-crf", "28",
        "-b:v", "500k",
        "-g", "50",
        "-bf", "2",
        "-an",
        "-vsync", "vfr",
        "-loglevel", "error",
        $fileName
    ) -NoNewWindow -Wait

    Write-Host "Recording finished: $fileName"

    # Обновляем свободное место после завершения записи
    $freeSpace = Check-FreeSpace
}
