$OutputEncoding = [System.Text.Encoding]::UTF8

$services = @("alco_backend", "alco_frontend")
$update_services = "alco_update"
foreach ($svc in $services) {
    if (Get-Service -Name $svc -ErrorAction SilentlyContinue) {
        Write-Output "Stopping $svc..."
        Stop-Service -Name $svc -Force
    }
}

[string]$zipPath = "C:\Builds\Latest.zip"
[string]$targetPath = "C:\Users\Алко-Инспектор\alco"

if (!(Test-Path $zipPath)) {
    Write-Output "ZIP file not found: $zipPath"
    exit 1
}

$tempExtractPath = "C:\alco_temp"

Write-Output "Extracting ZIP..."
Expand-Archive -Path $zipPath -DestinationPath $tempExtractPath -Force

Write-Output "Copying files..."
Copy-Item -Path "$tempExtractPath\combined\publish\*" -Destination $targetPath -Recurse -Force

Write-Output "Cleaning up..."
Remove-Item -Path $tempExtractPath -Recurse -Force -ErrorAction SilentlyContinue


foreach ($svc in $services) {
    if (Get-Service -Name $svc -ErrorAction SilentlyContinue) {
        Write-Output "Starting $svc..."
        Start-Service -Name $svc
    }
}

Write-Output "Stopping $update_services..."
Stop-Service -Name $update_services  -Force	

Write-Output "Update complete!"